 <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
        <x-nymt.html.title>
        Manage Roles for Project {{ $project->name }} - {{ date('Y-m-d' , strtotime($project->start_date)) }}
        </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    <a class="group" href="?view=grid" title="View Auditionees Grid" alt="View Auditionees Grid">Grid View</a> | 
    <a class="group" href="/projects/" title="View Projects" alt="View Projects Grid">Back to Projects</a>
    </div>
    </div>
    </x-slot>

    <x-nymt.body>


        <div class="flex">
            
	                    
          </div>
          <div class="flex-0">
          <div class="flex-none">
              <div class="m-2 p-2 text-right">
            {{ $myroles->onEachSide(0)->links() }}
              </div>
          </div>
          </div>

            <x-nymt.table>

                <x-slot name="head">


                        <x-nymt.table.heading>Role</x-nymt.table.heading>
                        <x-nymt.table.heading>Accepted?</x-nymt.table.heading>
                        <x-nymt.table.heading>Firstname</x-nymt.table.heading>
                        <x-nymt.table.heading>Lastname</x-nymt.table.heading>
                        <x-nymt.table.heading>Age</x-nymt.table.heading>
                        <x-nymt.table.heading>Gender</x-nymt.table.heading>
                        <x-nymt.table.heading>Tags</x-nymt.table.heading>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.heading>Availability Issues</x-nymt.table.heading>
                        @endif
                        <x-nymt.table.heading></x-nymt.table.heading>
                        
                        
                </x-slot>

                <x-slot name="body">

                    @foreach($myroles as $role)

                    <x-nymt.table.row>


                        <x-nymt.table.cell>{{ $role->name }}</x-nymt.table.cell>
                        @if (($role->audition_role) && ($role->audition_role->auditionee))
                        <x-nymt.table.cell>
                            
                            @switch($role->audition_role->status)
                                @case(2)
                                    Accepted
                                @break
                                @case(0)
                                    Declined
                                @break
                                @default
                                    Offered
                            @endswitch  
                        </x-nymt.table.cell>
                        <x-nymt.table.cell>{{ ucwords($role->audition_role?->auditionee?->firstname) }}
                        @if (!empty($role->audition_role?->auditionee?->pastoral->comment))
                        <div class="text-gray-500 mt-1">({{ $role->audition_role?->auditionee?->pastoral->comment }})</span>
                        @endif</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  ucwords($role->audition_role?->auditionee?->lastname) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $role->audition_role?->auditionee?->age() }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $role->audition_role?->auditionee?->gender }}</x-nymt.table.cell>
                        <x-nymt.table.cell>
                             @foreach($role->audition_role?->auditionee?->tags() as $key => $tag)
                            <x-nymt.html.tag tagType="{{ $key }}">{{ $tag }}</x-nymt.html.tag>
                            @endforeach
                        </x-nymt.table.cell>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.cell>{{ $role->audition_role?->auditionee?->unavailability }}</x-nymt.table.cell>
                        @endif
                        @else
                         <x-nymt.table.cell colspan="7">
                                <b>No YCM Yet</b>
                         </x-nymt.table.cell>
                        @endif
                        
                        <x-nymt.table.cell class="text-center">
                            
                            @if (($role->audition_role) && ($role->audition_role->auditionee))
                            @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                            <button
                            class="group text-center"
                            type="button"
                            wire:click="sendOffer({{ $role->audition_role->auditionee->id }},{{ $project->id }})" 
                            wire:confirm='Are you sure you want to send an offer reminder? This is not reversable.' 
                            ><x-nymt.icon.mail /></button>
                            @endif
                            <button type="button" 
                            class="group" 
                            wire:click="edit({{ $role->audition_role->auditionee->id }})" 
                            title="edit" alt="edit">
                            <x-nymt.icon.user-circle />
                            </button>
                            @endif
                         </x-nymt.table.cell>
                         
                       

                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>