<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        Manage Venues
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    </div>
</div>

</x-slot>

    <x-nymt.body>
        <div class="flex">
          <div class="flex-none">
              @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
            <x-nymt.button.primarylink href="{{ url('/venues/create') }}">Create Venue</x-nymt.button.primarylink>
                @endif
          </div>
            
	                    
          <div class="flex-1">
            <input wire:model.live="inputsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Search for name or town..."/>
          </div>
          
          <div class="flex-0">
              <div class="m-1 text-right">
                  <x-nymt.input.text leadingAddOn="Rows Per Page" placeholder="Enter Number of rows per page" wire:model.live.debounce.500ms="perPage" />
              </div>
          </div>
            
          </div>
          <div class="flex-1">
          <div class="flex-none">
              <div class="m-1 text-right">
            {{ $myvenues->onEachSide(0)->links() }}
              </div>
          </div>
          </div>
            <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading sortable wire:click="sortBy('name')" :direction="$sortField === 'name' ? $sortDirection : null">Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Address</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('town')" :direction="$sortField === 'town' ? $sortDirection : null">Town</x-nymt.table.heading>
                        <x-nymt.table.heading>Postcode</x-nymt.table.heading>
                        <x-nymt.table.heading>Website</x-nymt.table.heading>
                        {{-- <x-nymt.table.heading>Email</x-nymt.table.heading> --}}
                        {{--<x-nymt.table.heading>Tel</x-nymt.table.heading> --}}
                        {{--<x-nymt.table.heading>Capacity</x-nymt.table.heading> --}}
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.heading class="w-32">Action</x-nymt.table.heading>
                        @endif

                </x-slot>

                <x-slot name="body">

                    @foreach($myvenues as $venue)
                    
                    <x-nymt.table.row class="{{ $loop->index % 2 === 0 ? 'bg-gray-50' : '' }}">

                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'name'], key(rand() * $venue->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'address'], key(rand() * $venue->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'town'], key(rand() * $venue->id))</x-nymt.table.cell>

                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'postcode'], key(rand() * $venue->id))</x-nymt.table.cell>
                        
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'website'], key(rand() * $venue->id))</x-nymt.table.cell>

                        {{--<x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'email'], key(rand() * $venue->id))</x-nymt.table.cell>--}}

                        {{--<x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'tel'], key(rand() * $venue->id))</x-nymt.table.cell>--}}

                        {{--<x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venue->id,'object'=>'Venue','field'=>'capacity'], key(rand() * $venue->id))</x-nymt.table.cell>--}}
                    @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.cell>
                        
                        <x-nymt.icon.group>
                            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="edit({{ $venue->id }})" 
        
                            ><x-nymt.icon.edit /></button>
            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="delete({{ $venue->id }})" 
                            wire:confirm="Are you sure you want to delete this venue?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.icon.group>
                        
                        </x-nymt.table.cell>
                    @endif
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>