<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\ExportCsvController;

use App\Http\Controllers\Auth\AuditioneeParentLogoutController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Match my own domain
Route::domain('staging.nymt.smbsolutionsuk.net')->group(function () {
    // deal with parents
    Route::middleware(['auth:auditionee_parent'])->group(function () {
        Route::get('/ycm/profile', \App\Livewire\Frontend\Ycm\ParentProfile::class)->name('ycm.profile');
        Route::get('/ycm/profile/{formType}/{venue}/{applicationType}/{email}', \App\Livewire\Frontend\Ycm\ParentProfile::class)->name('ycm.profile.choice');
    });
    Route::middleware('guest:auditionee_parent')->group(function () {
        Route::get('/ycm/login', \App\Livewire\Frontend\Ycm\ParentLogin::class)->name('ycm.login');
        Route::get('/ycm/forgot-password', \App\Livewire\Frontend\Ycm\ParentForgotPassword::class)->name('ycm.password.request');
        Route::get('/ycm/reset-password/{token}', \App\Livewire\Frontend\Ycm\ParentResetPassword::class)->name('ycm.password.reset');
    });
    
    Route::post('/ycm/logout', [AuditioneeParentLogoutController::class, 'logout'])
        ->middleware('auth:auditionee_parent')
        ->name('ycm.logout');
    
    Route::middleware('guest')->get('/', \App\Livewire\Frontend\Welcome::class)->name('ycm.audition');
    Route::middleware('guest')->get('/start/{venue}/{applicationType}', \App\Livewire\Frontend\Start::class)->name('ycm.audition.start');
    Route::middleware('guest')->get('/signup/{venue}/{applicationType}', \App\Livewire\Frontend\Register::class)->name('ycm.audition.signup');
    Route::middleware('guest')->get('/signup/{venue}/{applicationType}/{email}', \App\Livewire\Frontend\Register::class)->name('ycm.audition.signupwithmail');
    
    Route::get('/signup-course/{id}', \App\Livewire\Frontend\CourseRegistrationYcm::class)->middleware(['signed'])->name('ycm.course');
    Route::middleware('guest')->get('/signup-course', \App\Livewire\Frontend\CourseRegistration::class)->name('ycm.course.guest');
    
    Route::get('/auditionee-details/{id}',\App\Livewire\Frontend\AuditioneeProfile::class)
        ->middleware(['signed'])
        ->name('auditionee.details');
        
    Route::get('/ycm/profile/{id}',\App\Livewire\Frontend\Ycm\Profile::class)
        ->middleware(['signed'])
        ->name('ycm.details');
        
    Route::get('/ycm/casting/{projectid}/{id}',\App\Livewire\Frontend\RoleAcceptanceYcm::class)
        ->middleware(['signed'])
        ->name('ycm.casting');
        
    
    // deal with payment
    Route::middleware('guest')->get('/pay/{id}', \App\Livewire\Frontend\PayController::class)->name('paypal');
    
    Route::middleware('guest')->get('/paypal/payment', [\App\Livewire\Frontend\PayController::class, 'payment'])->name('paypal.payment');
    Route::middleware('guest')->get('/paypal/payment/success', [\App\Livewire\Frontend\PayController::class, 'paymentSuccess'])->name('paypal.payment.success');
    Route::middleware('guest')->get('/paypal/payment/cancel', [\App\Livewire\Frontend\PayController::class, 'paymentCancel'])->name('paypal.payment.cancel');
    
    
    Route::middleware('guest')->get('/payCourse/{id}/{course}', \App\Livewire\Frontend\PayCourseController::class)->name('paypalCourse');
    Route::middleware('guest')->get('/paypalCourse/payment', [\App\Livewire\Frontend\PayCourseController::class, 'payment'])->name('paypalCourse.payment');
    Route::middleware('guest')->get('/paypalCourse/payment/success', [\App\Livewire\Frontend\PayCourseController::class, 'paymentSuccess'])->name('paypalCourse.payment.success');
    Route::middleware('guest')->get('/paypalCourse/payment/cancel', [\App\Livewire\Frontend\PayCourseController::class, 'paymentCancel'])->name('paypalCourse.payment.cancel');
    
    
    Route::paypalWebhooks('/webhooks/paypal');
});

Route::paypalWebhooks('/webhooks/paypal');


Route::get('/', function () {
    return view('nymt.welcome');
});

// auditionees
Route::middleware(['auth:sanctum', 'verified'])->get('/auditionees', \App\Livewire\Auditionees::class)->name('auditionees');
Route::middleware(['auth:sanctum', 'verified'])->get('/auditionees/edit/{id}', \App\Livewire\Auditionee\Edit::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/auditionees/create', \App\Livewire\Auditionee\Edit::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/auditionees/audition-list/{id}', \App\Livewire\Auditionee\AuditionList::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/auditionees/attendee-list/{id}', \App\Livewire\Auditionee\AttendeeList::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/auditionees/audition-notes/{id}', \App\Livewire\Auditionee\AuditionNote::class);

Route::middleware(['auth:sanctum', 'verified'])->get('/guardians', \App\Livewire\Guardians::class)->name('guardians');

Route::middleware(['auth:sanctum', 'verified'])->get('/auditonee-roles/create', \App\Livewire\Auditionee\EditRole::class);

//courses
Route::middleware(['auth:sanctum', 'verified'])->get('/courses', \App\Livewire\Courses::class)->name('courses');
Route::middleware(['auth:sanctum', 'verified'])->get('/courses/edit/{id}', \App\Livewire\Course\Edit::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/courses/create', \App\Livewire\Course\Edit::class);

// venues
Route::middleware(['auth:sanctum', 'verified'])->get('/venues', \App\Livewire\Venues::class)->name('venues');
Route::middleware(['auth:sanctum', 'verified'])->get('/venues/edit/{id}', \App\Livewire\Venue\Edit::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/venues/create', \App\Livewire\Venue\Edit::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/venuedates', \App\Livewire\VenueDates::class)->name('venuedates');
Route::middleware(['auth:sanctum', 'verified'])->get('/venuedates/edit/{id}', \App\Livewire\Venue\EditDate::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/venuedates/create', \App\Livewire\Venue\EditDate::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/venuedates/create/{venue}', \App\Livewire\Venue\EditDate::class);

// projects
Route::middleware(['auth:sanctum', 'verified'])->get('/projects', \App\Livewire\Projects::class)->name('projects');
Route::middleware(['auth:sanctum', 'verified'])->get('/projects/edit/{id}', \App\Livewire\Project\Edit::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/projects/create', \App\Livewire\Project\Edit::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/roles', \App\Livewire\Roles::class)->name('roles');
Route::middleware(['auth:sanctum', 'verified'])->get('/roles/edit/{id}', \App\Livewire\Project\EditRole::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/roles/create', \App\Livewire\Project\EditRole::class);
Route::middleware(['auth:sanctum', 'verified'])->get('/roles/create/{project}', \App\Livewire\Project\EditRole::class);

Route::middleware(['auth:sanctum', 'verified'])->get('/roles/list/{id}', \App\Livewire\Project\RoleList::class);

// exports+

Route::middleware(['auth:sanctum', 'verified'])->get('/export-csv/{model}/{ids}', [ExportCsvController::class, 'export']);
Route::middleware(['auth:sanctum', 'verified'])->get('/export-csv-all', [ExportController::class, 'exportCsv']);


Route::middleware(['auth:sanctum', 'verified'])->get('/comment-categories', \App\Livewire\CommentCategories::class)->name('comment-categories');


Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        return view('nymt.dashboard');
    })->name('dashboard');
});
